﻿-----------------------------------------------------------------------------------
use AdventureWorksOBP
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 1.
/*
PRETVARANJE TIPOVA PODATAKA
Dohvatite brojeve računa i datume izdavanja za kupca s ID-em 378.
Datume izdavanja formatirajte na hrvatski naèin.
*/
SELECT	
	BrojRacuna,
	CONVERT(char(10), DatumIzdavanja, 104) AS DatumIzdavanja
FROM Racun WHERE KupacID = 378
GO
-----------------------------------------------------------------------------------
-- Zadatak 2.
/*
PRETVARANJE TIPOVA PODATAKA
Napišite proceduru za umetanje zapisa u tablicu Drzava. 
Neka procedura kroz izlazni parametar vrati vrijednost primarnog kljuèa novog zapisa. 
Pozovite proceduru i ispišite vraæenu vrijednost u formatu: 
“Umetnuta je država s ID-em n”, gdje je n vrijednost primarnog kljuèa.
*/
CREATE PROC p1
	@Naziv nvarchar(50),
	@ID int OUTPUT
AS
INSERT INTO Drzava (Naziv) VALUES (@Naziv)
SET @ID = SCOPE_IDENTITY()
GO

DECLARE @n int
EXEC p1 'Gruzija', @n OUTPUT
PRINT 'Umetnuta je država s ID-em ' + CAST(@n AS nvarchar(10))
GO
-----------------------------------------------------------------------------------
-- Zadatak 3.
/*
PRETVARANJE TIPOVA PODATAKA
Dohvatite nazive svih proizvoda i uz svaki naziv u zagradi 
ispišite i njegov ID te cijenu, 
npr. “HL Road Rear Wheel (ID = 828, Cijena = 357.06)”
*/
SELECT 
	Naziv + ' (ID = ' + CAST(IDProizvod AS nvarchar(50)) + ', Cijena = ' + CAST(CijenaBezPDV AS nvarchar(50)) + ')' AS Naziv
FROM dbo.Proizvod
-----------------------------------------------------------------------------------
-- Zadatak 4.
/*
NAREDBA CASE I WHILE
Dohvatite nazive svih proizvoda i uz svaki naziv ispišite i naziv potkategorije. 
Ako neke potkategorije nema, napišite “Nije definirana”.
*/
SELECT 
	p.Naziv,
	CASE
		WHEN pk.Naziv IS NULL THEN 'Nije definirana'
		ELSE pk.Naziv
	END AS NazivPotkategorije
FROM Proizvod AS p
LEFT JOIN Potkategorija AS pk ON p.PotkategorijaID = pk.IDPotkategorija
-----------------------------------------------------------------------------------
-- Zadatak 5.
/*
NAREDBA CASE I WHILE
Dohvatite naziv i cijene svih proizvoda. 
Za cijene koje su ispod 1000, napišite “Jeftino”, izmeðu 1000 i 2000 
napišite “Prihvatljivo”, za sve ostale napišite “Skupo”.
*/
SELECT 
	Naziv,
	CASE
		WHEN CijenaBezPDV < 1000 THEN 'Jeftino'
		WHEN CijenaBezPDV BETWEEN 1000 AND 2000 THEN 'Prihvatljivo'
		ELSE 'Skupo'
	END AS Procjena
FROM Proizvod
GO
-----------------------------------------------------------------------------------
-- Zadatak 6.
/*
NAREDBA CASE I WHILE
Napravite tablicu Proba sa stupcima IDProba (primarni kljuè i IDENTITY) i Vrijednost (int). 
U stupac Vrijednost unesite vrijednosti izmeðu 10.000.000 i 10.015.000.
*/
CREATE TABLE Proba ( IDProba int PRIMARY KEY IDENTITY, Vrijednost int )
GO

DECLARE @i int = 10000000
WHILE @i <= 10015000 BEGIN
	INSERT INTO Proba VALUES (@i)
	SET @i += 1
END

SELECT * FROM Proba
GO

-----------------------------------------------------------------------------------
-- Zadatak 7.
/*
STRUKTURIRANO HVATANJE POGREŠAKA
Napravite proceduru koja prima dva broja i kroz izlazni parametar 
vraæa prvi broj podijeljen drugim. 
Ako se desi greška, neka procedura u izlazni parametar upiše 0 
i neka ispiše tekst greške. 
Pozovite proceduru i ispišite rezultat dijeljenja.
*/
create PROC pp2
	@a int,
	@b int,
	@c int OUTPUT
AS
BEGIN TRY
	SET @c = @a / @b
END TRY
BEGIN CATCH
	SET @c = 0
	PRINT ERROR_MESSAGE()
END CATCH
GO

DECLARE @Rez int
EXEC pp2 32, 4, @Rez OUTPUT
PRINT @Rez

EXEC pp2 32, 0, @Rez OUTPUT
PRINT @Rez
GO
-----------------------------------------------------------------------------------
-- Zadatak 8.
/*
STRUKTURIRANO HVATANJE POGREŠAKA
Napravite tablicu Zivotinja koja ima stupce IDZivotinja 
(primarni kljuè, ali nije IDENTITY) i Naziv. 
Napravite proceduru koja prima IDZivotinja i Naziv i umeæe ih u tablicu. 
Pozovite proceduru dva puta s vrijednostima 20 i "Čaplja".
Implementirajte TRY/CATCH izvan procedure i pozovite je.
Implementirajte TRY/CATCH unutar procedure i pozovite je.
*/
CREATE TABLE Zivotinja 
(
	IDZivotinja int PRIMARY KEY,
	Naziv nvarchar(50)
)
GO

CREATE PROC InsertZivotinja 
	@IDZivotinja int,
	@Naziv nvarchar(50)
AS
INSERT INTO Zivotinja (IDZivotinja, Naziv) VALUES (@IDZivotinja, @Naziv)
GO

EXEC InsertZivotinja 20, 'Èaplja'
EXEC InsertZivotinja 20, 'Èaplja'
GO

BEGIN TRY
	EXEC InsertZivotinja 20, 'Èaplja'
	EXEC InsertZivotinja 20, 'Èaplja'
END TRY
BEGIN CATCH
	PRINT 'Error message: ' + cast(ERROR_MESSAGE() as nvarchar(100))
	PRINT 'Error number: ' + cast(ERROR_NUMBER() as nvarchar(100))
	PRINT 'Error severity: ' + cast(ERROR_SEVERITY() as nvarchar(100))
	PRINT 'Error line ' + cast(ERROR_LINE() as nvarchar(100))
	PRINT 'Error procedure: ' + cast(ERROR_PROCEDURE() as nvarchar(100))
END CATCH
GO

ALTER PROC InsertZivotinja 
	@IDZivotinja int,
	@Naziv nvarchar(50)
AS
BEGIN TRY
	INSERT INTO Zivotinja (IDZivotinja, Naziv) VALUES (@IDZivotinja, @Naziv)
END TRY
BEGIN CATCH
	PRINT 'Desila se greška: ' + ERROR_MESSAGE()
	PRINT 'Životinja nije upisana.'
END CATCH
GO

EXEC InsertZivotinja 20, 'Čaplja'
GO


-----------------------------------------------------------------------------------
-- Zadatak 9.
/*
CRUD OPERACIJE
Svaka operacija posebno.
Napravite procedure koje rade CRUD operacije 
na tablici Student tako da svakoj operaciji 
dodijelite posebnu proceduru. 
Iskoristite procedure za umetanje, izmjenu, 
dohvaćanje i brisanje zapisa.
*/

CREATE PROC InsertStudent
	@IDStudent int OUTPUT, 
	@Ime nvarchar(50), 
	@Prezime nvarchar(50), 
	@JMBAG char(11)
AS
INSERT INTO Student (Ime, Prezime, JMBAG) VALUES (@Ime, @Prezime, @JMBAG)
SET @IDStudent = SCOPE_IDENTITY()
GO

CREATE PROC UpdateStudent
	@IDStudent int, 
	@Ime nvarchar(50), 
	@Prezime nvarchar(50), 
	@JMBAG char(11)
AS
UPDATE Student 
SET Ime = @Ime, Prezime = @Prezime, JMBAG = @JMBAG
WHERE IDStudent = @IDStudent
GO

CREATE PROC DeleteStudent
	@IDStudent int
AS
DELETE FROM Student WHERE IDStudent = @IDStudent
GO

CREATE PROC GetStudent
	@IDStudent int
AS
SELECT * FROM Student WHERE IDStudent = @IDStudent
GO

EXEC GetStudent 1

DECLARE @NoviIDStudenta int
EXEC InsertStudent @IDStudent = @NoviIDStudenta OUTPUT, 
	@Ime = 'Ana', @Prezime = 'Aniæ', @JMBAG = '11224451253'
PRINT @NoviIDStudenta

EXEC GetStudent 1

EXEC UpdateStudent 1, 'Ana', 'Aniæ Miriæ', '11224451253'

EXEC GetStudent 1

EXEC DeleteStudent 1

EXEC GetStudent 1
GO
-----------------------------------------------------------------------------------
-- Zadatak 10.
/*
CRUD OPERACIJE
INSERT/UPDATE zajedno, ostalo posebno.
Napravite procedure koje rade CRUD operacije na tablici Student 
tako da operacije umetanja i izmjene obavite u jednoj proceduri, 
a druge dvije operacije obavite u posebnim procedurama. 
Iskoristite procedure za umetanje, izmjenu, dohvaæanje i brisanje zapisa.
*/
CREATE PROC MergeStudent
	@IDStudent int OUTPUT, 
	@Ime nvarchar(50), 
	@Prezime nvarchar(50), 
	@JMBAG char(11)
AS
IF Exists(SELECT * FROM Student WHERE IDStudent = @IDStudent)
	UPDATE Student 
	SET Ime = @Ime, Prezime = @Prezime, JMBAG = @JMBAG
	WHERE IDStudent = @IDStudent
ELSE
	INSERT INTO Student (Ime, Prezime, JMBAG) VALUES (@Ime, @Prezime, @JMBAG)
	SET @IDStudent = SCOPE_IDENTITY()
GO

CREATE PROC DeleteStudent
	@IDStudent int
AS
DELETE FROM Student WHERE IDStudent = @IDStudent
GO

CREATE PROC GetStudent
	@IDStudent int
AS
SELECT * FROM Student WHERE IDStudent = @IDStudent
GO

EXEC GetStudent 1

DECLARE @NoviIDStudenta int
EXEC MergeStudent @NoviIDStudenta OUTPUT, 'Ana', 'Anić', '11224451253'
PRINT @NoviIDStudenta

EXEC GetStudent 2

EXEC MergeStudent 2, 'Ana', 'Aniæ Mirić', '11224451253'

EXEC GetStudent 2

EXEC DeleteStudent 2

EXEC GetStudent 2
GO
-----------------------------------------------------------------------------------
-- Zadatak 11.
/*
CRUD OPERACIJE
UPDATE/INSERT/DELETE zajedno.
Napravite procedure koje rade CRUD operacije na tablici Student 
tako da operacije umetanja, izmjene i brisanja obavite u jednoj proceduri, 
a dohvaćanje u drugoj. 
Iskoristite procedure za umetanje, izmjenu, dohvaæanje i brisanje zapisa.
*/
CREATE PROC ChangeStudent
	@Operacija char(1),
	@IDStudent int OUTPUT, 
	@Ime nvarchar(50), 
	@Prezime nvarchar(50), 
	@JMBAG char(11)
AS
IF @Operacija = 'U'
	UPDATE Student 
	SET Ime = @Ime, Prezime = @Prezime, JMBAG = @JMBAG
	WHERE IDStudent = @IDStudent
ELSE IF @Operacija = 'I' BEGIN
	INSERT INTO Student (Ime, Prezime, JMBAG) VALUES (@Ime, @Prezime, @JMBAG)
	SET @IDStudent = SCOPE_IDENTITY()
END
ELSE IF @Operacija = 'D'
	DELETE FROM Student WHERE IDStudent = @IDStudent
GO

CREATE PROC GetStudent
	@IDStudent int
AS
SELECT * FROM Student WHERE IDStudent = @IDStudent
GO

EXEC GetStudent 3

DECLARE @NoviIDStudenta int
EXEC ChangeStudent 'I', @NoviIDStudenta OUTPUT, 'Ana', 'Aniæ', '11224451253'
PRINT @NoviIDStudenta

EXEC GetStudent 3

EXEC ChangeStudent 'U', 3, 'Ana', 'Aniæ Miriæ', '11224451253'

EXEC GetStudent 3

EXEC ChangeStudent 'D', 3, null, null, null

EXEC GetStudent 3
GO
-----------------------------------------------------------------------------------
-- Zadatak 12.
/*
CRUD OPERACIJE
Za tablicu Student koja se sastoji od IDStudent, Ime, Prezime i JMBAG 
implementirajte tabličnom funkcijom operaciju SELECT. 
Iskoristite funkciju za dohvaćanje zapisa.
*/

create function fStudent
(
	@IDStudent int
)
returns table
as
return
	select *
	from Student
	where IDStudent=@IDStudent
go

select * from dbo.fStudent(5)
-----------------------------------------------------------------------------------
